function hours, t1, t0

;+
; HOURS
;	returns the difference in hours between two times.
;
; Usage;
;	dt = hours(t1, t0)
;
; Return Value:
;	dt	float	The difference in hours between the two times.
;
; Arguments:
;	t1	int/float	input	The "later" time in array [y,d,h,m,s]
;	t0	int/float	input	The "earlier" time
;
; Method:
;	Returns t1 - t0 with due allowance for leap years.
;
; History:
;	Original: 7/6/93; SJT
;	Fix negative difference crossing year boundary: 28/10/93; SJT
;	Fix for century boundary: 1/12/95; SJT
;-

dhms = [1./24., 1., 60., 3600.]

;		Extend to ensure that we don't truncate minutes and
;		seconds. Also ensure that 1992 == 92 in the year.

tt1 = [t1,0,0,0,0]
tt0 = [t0,0,0,0,0]

tt0(0) = date100(tt0(0))
tt1(0) = date100(tt1(0))

;		Except for the years, its very simple.

dt = total((tt1(1:*) - tt0(1:*))/dhms)

;		If the times are in different years, then for each year
;		end crossed, we must add the length of the completed
;		year in hours.

if (tt1(0) gt tt0(0)) then for i = tt0(0),tt1(0)-1 do begin
    ily = 365 + (i mod 4 eq 0) 	; OK up to 2100 and back to 1900
    dt = dt + 24.*ily
endfor else if (tt1(0) lt tt0(0)) then for i = tt1(0),tt0(0)-1 do begin
    ily = 365 + (i mod 4 eq 0) 	; OK up to 2100 and back to 1900
    dt = dt - 24.*ily
endfor

return, dt

end
